<?php
$proc = <<<'EOP'
    declare
        type typ_kursor is ref cursor;
        kursor typ_kursor;
    begin
        open kursor for select pNazwisko,stanowisko,dzialId from prac;
        :KRS:=kursor;
    end;
EOP;
try {
    $dbh = oci_connect("test", "test", "localhost");
    if (!$dbh) {
        $err = oci_error();
        throw new exception($err['message']);
    }
    $krs = oci_new_cursor($dbh);
    $res = oci_parse($dbh, $proc);
    oci_bind_by_name($res, ":KRS", $krs, -1, SQLT_RSET);
    if (!oci_execute($res)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    if (!oci_execute($krs)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    while ($wiersz = oci_fetch_array($krs, OCI_NUM)) {
        foreach ($wiersz as $r) {
            printf("%-12s", $r);
        }
        print "\n";
    }
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage() . "\n");
}
?>
