<?php
if ($argc != 4) {
    die("SPOSÓB UŻYCIA:listing9_1 <połączenie> <nazwa_tabeli> <nazwa pliku>\n");
}
$polaczenie = $argv[1];   
$nazwaTabeli = $argv[2];
$nazwaPliku = $argv[3];
$zapytanie = "select * from $nazwaTabeli";
$dsn = array();
$liczbaWierszy = 0;
if (preg_match('/(.*)\/(.*)@(.*)/', $polaczenie, $dsn)) {
    $polaczenie = array_shift($dsn);
} elseif (preg_match('/(.*)\/(.*)/', $polaczenie, $dsn)) {
    $polaczenie = array_shift($dsn);
} else die("Identyfikator połączenia powinien mieć formę u/h@baza.");
if (count($dsn) == 2) {
    $dsn[2] = "";
}
function utworz_polecenie_insert($tabela, $liczbaKolumn) {      
    $zapytanie = "insert into $tabela values(";
    foreach (range(1, $liczbaKolumn) as $i) {
        $zapytanie.= ":$i,";
    }
    $zapytanie = preg_replace("/,$/", ')', $zapytanie);
    return ($zapytanie);
}
try {
    $dbh = oci_connect($dsn[0], $dsn[1], $dsn[2]);
    if (!$dbh) {
        $err = oci_error();
        throw new exception($err['message']);
    }
    $res = oci_parse($dbh, $zapytanie);
    // Oracle musi wykonać polecenie, zanim funkcje opisujące będą dostępne. 
    // Dostępny jest jednak specjalny tryb wywoływania poleceń, 
    // dzięki któremu nie ma problemów z wydajnością.
    if (!oci_execute($res, OCI_DESCRIBE_ONLY)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    $liczbaKolumn = oci_num_fields($res);
    oci_free_statement($res);
    $ins = utworz_polecenie_insert($nazwaTabeli, $liczbaKolumn);
    $res = oci_parse($dbh, $ins);
    $fp = new SplFileObject($nazwaPliku, "r");
    while ($wiersz = $fp->fgetcsv()) {
        if (count($wiersz) < $liczbaKolumn) continue;
        foreach (range(1, $liczbaKolumn) as $i) {
            oci_bind_by_name($res, ":$i", $wiersz[$i - 1]);
        }
        if (!oci_execute($res,OCI_NO_AUTO_COMMIT)) {
            $err = oci_error($dbh);
            throw new exception($err['message']);
        }
        $liczbaWierszy++;
    }
    oci_commit($dbh);
    print "Do tabeli $nazwaTabeli wstawiono $liczbaWierszy wierszy.\n";
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage() . "\n");
}
?>
