<?php
if ($argc != 3) {
    die("SPOSÓB UŻYCIA: skrypt7.11 <nazwa_tabeli> <nazwa pliku>\n");
}
$nazwaTabeli = $argv[1];
$nazwaPliku = $argv[2];
$liczbaWierszy = 0;

function utworz_polecenie_insert($tabela, $liczbaKolumn) {
    $polecenie = "insert into $tabela values(";
    foreach(range(1,$liczbaKolumn) as $i) {   
        $polecenie.= ":$i,";
    }
    $polecenie = preg_replace("/,$/", ')', $polecenie);
    return ($polecenie);
}
try {
    $db = new SQLite3("test.sqlite");
    $res = $db->query("select * from $nazwaTabeli");
    if ($db->lastErrorCode() != 0) {
        throw new Exception($db->lastErrorMsg());
    }
    $liczbaKolumn = $res->numColumns();
    $res->finalize();
    $ins = utworz_polecenie_insert($nazwaTabeli, $liczbaKolumn);
    print "Polecenie insert: $ins\n";
    $res = $db->prepare($ins);
    $plik=new SplFileObject($nazwaPliku,"r");
    while ($wiersz = $plik->fgetcsv()) {
        if (strlen(implode('',$wiersz))==0) continue;
        foreach(range(1,$liczbaKolumn) as $i) {
            $res->bindValue(":$i", $wiersz[$i - 1]);
        }
        $res->execute();
        if ($db->lastErrorCode() != 0) {
            print_r($wiersz);
            throw new Exception($db->lastErrorMsg());
        }
        $liczbaWierszy++;
    }
    print "Do tabeli $nazwaTabeli wstawiono $liczbaWierszy wierszy.\n";
}
catch(Exception $e) {
  print "Wyjątek:\n";
  die($e->getMessage() . "\n");
}
?>
