<?php
$DDL = <<<EOT
CREATE TABLE dzial
(
    dzialId integer NOT NULL,
    dNazwa text,
    lokalizacja text,
    CONSTRAINT dzial_pkey PRIMARY KEY (dzialId)
);
CREATE TABLE prac
(
    pId integer NOT NULL,
    pNazwisko text ,
    stanowisko text ,
    men integer,
    datazatrudnienia text,
    pensja real,
    prowizja real,
    dzialId integer,
    CONSTRAINT prac_pkey PRIMARY KEY (pId),
    CONSTRAINT fk_dzialId FOREIGN KEY (dzialId)
    REFERENCES dzial (dzialId) ON DELETE CASCADE
);
CREATE UNIQUE INDEX pk_prac on prac(pId);
CREATE INDEX prac_dzialId on prac(dzialId);
CREATE UNIQUE INDEX pk_dzial on dzial(dzialId);
EOT;
try {
    $db = new SQLite3("test.sqlite");
    @$db->exec($DDL);
    if ($db->lastErrorCode() != 0) {
        throw new Exception($db->lastErrorMsg()."\n");
    }
    print "Struktura bazy utworzona pomyślnie.\n";
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage());
}
?>
