<?php
class iterator_pliku implements iterator {
    private $fp;
    private $indeks = 0;
    private $linia;
    function __construct($nazwa) {
        $fp = fopen($nazwa, "r");
        if (!$fp) {
            die("Nie mogę otworzyć pliku $nazwa do odczytu.\n");
        }
        $this->fp = $fp;
        $this->linia = rtrim(fgets($this->fp), "\n");
    }
    function rewind() {
        $this->indeks = 0;
        rewind($this->fp);
        $this->linia = rtrim(fgets($this->fp), "\n");
    }
    function current() {
        return ($this->linia);
    }
    function key() {
        return ($this->indeks);
    }
    function next() {
        $this->indeks++;
        $this->linia = rtrim(fgets($this->fp), "\n");
        if (!feof($this->fp)) {
            return ($this->linia);
        } else {
            return (NULL);
        }
    }
    function valid() {
        return (feof($this->fp) ? FALSE : TRUE);
    }
}
$x = new iterator_pliku("qbf.txt");
foreach ($x as $numer_linii => $wartosc) {
    print "$numer_linii:\t$wartosc\n";
}