<?php
class Spacer
{
    private $klucze_opcji = array('posiadaszPsa', 'jestesZmeczony', 'nieSpacerowalesOdDawna', 'ladnaPogoda', 'jestesZnudzony');
    private $opcje = array();
    
    public function __construct()
    {
        foreach ($this->klucze_opcji as $klucz) {
            $this->opcje[$klucz] = true;
        }
    }      
    
    public function ruszSie()
    {
        if ($this->czyIscNaSpacer()) {
            $this->idzNaSpacer();
        }
    }
    
    public function czyIscNaSpacer()
    {
        return ($this->czasWyprowadzicPsa() || $this->ochotaNaSpacer());
    }
    
    public function czasWyprowadzicPsa()
    {
        return ($this->opcje['posiadaszPsa'] && (!$this->opcje['jestesZmeczony'] || $this->opcje['nieSpacerowalesOdDawna']));
    }
    
    public function ochotaNaSpacer()
    {
        return (($this->opcje['ladnaPogoda'] && !$this->opcje['jestesZmeczony']) || $this->opcje['jestesZnudzony']);
    }
    
    public function __set($nazwa, $wartosc)
    {
        if (in_array($nazwa, $this->klucze_opcji)) {
            $this->opcje[$nazwa] = $wartosc;
        }
    }
    private function idzNaSpacer()
    {
        echo "Idę na spacer.";
    }
}
//$spacer = new Spacer();
//$spacer->ruszSie();
?>
