<?php

abstract class BookPrototype {
    protected $title;
    protected $topic;
    abstract function __clone();
    function getTitle() {
        return $this->title;
    }
    function setTitle($titleIn) {
        $this->title = $titleIn;
    }
    function getTopic() {
        return $this->topic;
    }
}

class PHPBookPrototype extends BookPrototype {
    function __construct() {
        $this->topic = 'PHP';
    }
    function __clone() {
    }
}

class SQLBookPrototype extends BookPrototype {
    function __construct() {
        $this->topic = 'SQL';
    }
    function __clone() {
    }
}
 
  writeln('ROZPOCZYNAM TESTOWANIE WZORCA PROTOTYP');
  writeln('');

  $phpProto = new PHPBookPrototype();
  $sqlProto = new SQLBookPrototype();

  $book1 = clone $sqlProto;
  $book1->setTitle('SQL dla kotów');
  writeln('Temat z 1 ksiażki: '.$book1->getTopic());
  writeln('Temat z 1 ksiażki: '.$book1->getTitle());
  writeln('');

  $book2 = clone $phpProto;
  $book2->setTitle('Nauka PHP 5');
  writeln('Temat z 2 ksiażki: '.$book2->getTopic());
  writeln('Temat z 2 ksiażki: '.$book2->getTitle());
  writeln('');

  $book3 = clone $sqlProto;
  $book3->setTitle('Nauka SQL');
  writeln('Temat z 3 ksiażki: '.$book3->getTopic());
  writeln('Temat z 3 ksiażki: '.$book3->getTitle());
  writeln('');

  writeln('KONIEC TESTU WZORCA PROTOTYP');

  function writeln($line_in) {
    echo $line_in."<br/>";
  }

?>