<?php

namespace popp\r11\zestaw01;

class Runner
{
    public static function run()
    {
/* listing 11.04 */
        $context = new InterpreterContext();
        $literal = new LiteralExpression('cztery');
        $literal->interpret($context);
        print $context->lookup($literal) . "\n";
/* /listing 11.04 */
    }


    public static function run2()
    {
/* listing 11.06 */
        $context = new InterpreterContext();
        $myvar = new VariableExpression('input', 'cztery');
        $myvar->interpret($context);
        print $context->lookup($myvar) . "\n";
        // wydruk: cztery

        $newvar = new VariableExpression('input');
        $newvar->interpret($context);
        print $context->lookup($newvar) . "\n";
        // wydruk: cztery

        $myvar->setValue("pięć");
        $myvar->interpret($context);
        print $context->lookup($myvar) . "\n";
        // wydruk: pięć
        print $context->lookup($newvar) . "\n";
        // wydruk: pięć
/* /listing 11.06 */
    }

    public static function run3()
    {
/* listing 11.11 */
        $context = new InterpreterContext();
        $input = new VariableExpression('input');
        $statement = new BooleanOrExpression(
            new EqualsExpression($input, new LiteralExpression('cztery')),
            new EqualsExpression($input, new LiteralExpression('4'))
        );
/* /listing 11.11 */

/* listing 11.12 */
        foreach (array( "cztery", "4", "52" ) as $val) {
            $input->setValue($val);
            print "$val:\n";
            $statement->interpret($context);
            if ($context->lookup($statement)) {
                print "Znakomita odpowiedź\n\n";
            } else {
                print "Do oślej ławki\n\n";
            }
        }
/* /listing 11.12 */
    }
}
