<?php
declare(strict_types = 1);

namespace popp\r12\zestaw08;

use popp\r12\zestaw06\Registry;
use popp\r12\zestaw06\Request;
use popp\r12\zestaw06\HttpRequest;
use popp\r12\zestaw08\CliRequest;

/* listing 12.33 */
abstract class PageController
{
    private $reg;

    abstract public function process();

    public function __construct()
    {
        $this->reg = Registry::instance();
    }

    public function init()
    {
        if (isset($_SERVER['REQUEST_METHOD'])) {
            $request = new HttpRequest();
        } else {
            $request = new CliRequest();
        }

        $this->reg->setRequest($request);
    }

    public function forward(string $resource)
    {
        $request = $this->getRequest();
        $request->forward($resource);
    }

    public function render(string $resource, Request $request)
    {
        include($resource);
    }

    public function getRequest()
    {
        return $this->reg->getRequest();
    }
}
/* /listing 12.33 */
