<?php
declare(strict_types = 1);

namespace popp\dodB\zestaw01\marklogic;

use popp\dodB\zestaw01\parse\Handler;
use popp\dodB\zestaw01\parse\Parser;
use popp\dodB\zestaw01\parse\Scanner;

use popp\dodB\zestaw01\interpreter\VariableExpression;

/* listing 24.17 */
class VariableHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner)
    {
        $varname = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new VariableExpression($varname));
    }
}
