<?php

namespace popp\r03;

require_once("vendor/autoload.php");

// nie ma potrzeby tworzyć kopii w tym zestawie
use popp\r03\zestaw04\ShopProduct;
use popp\r03\zestaw07\ShopProductWriter;
use popp\r03\zestaw07\Runner;

class Batch07Test extends \PHPUnit_Framework_TestCase
{
    public function testProductWriter()
    {
        
        $product = new ShopProduct("tytuł", "imię", "nazwisko", 99);
        self::assertTrue($product instanceof ShopProduct);
        self::assertEquals($product->title, "tytuł");
        self::assertEquals($product->producerFirstName, "imię");
        self::assertEquals($product->producerMainName, "nazwisko");
        self::assertEquals($product->price, 99);
        $spw = new ShopProductWriter();

        ob_start();
        $spw->write($product);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("tytuł: imię nazwisko (99)\n", $output1);
       
        ob_start();
        Runner::run1();
        $output2 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("Moja Antonia: Willa Cather (5.99)\n", $output2);

    }
}
