<?php
declare(strict_types = 1);

namespace popp\r13\zestaw07;

/* listing 13.37 */
class Field
{
    protected $name = null;
    protected $operator = null;
    protected $comps = [];
    protected $incomplete = false;

    // ustawia nazwę pola (np. age)
    public function __construct(string  $name)
    {
        $this->name = $name;
    }

    // dodaje operator i wartość kryterium (np. > 40)
    // i dodaje kryterium do składowej $comps
    public function addTest(string $operator, $value)
    {
        $this->comps[] = [
            'name' => $this->name,
            'operator' => $operator,
            'value' => $value
        ];
    }

    // $comps to tablica, można więc testować dane pole większą
    // niż 1 liczbą warunków
    public function getComps(): array
    {
        return $this->comps;
    }

    // jeśli $comps nie zawiera żadnych elementów, pole nie
    // jest gotowe do użycia w zapytaniu
    public function isIncomplete(): bool
    {
        return empty($this->comps);
    }
}
