<?php
declare(strict_types = 1);

namespace popp\r18\zestaw01;

/* listing 18.01 */
class UserStore
{
    private $users = [];

    public function addUser(string $name, string $mail, string $pass):bool
    {
        if (isset($this->users[$mail])) {
            throw new \Exception(
                "Konto {$mail} już istnieje w systemie"
            );
        }

        if (strlen($pass) < 5) {
            throw new \Exception(
                "Hasło musi mieć co najmniej 5 liter"
            );
        }

        $this->users[$mail] = [
            'pass' => $pass,
            'mail' => $mail,
            'name' => $name
        ];

        return true;
    }

    public function notifyPasswordFailure(string $mail)
    {
        if (isset($this->users[$mail])) {
            $this->users[$mail]['failed'] = time();
        }
    }


    public function getUser(string $mail):array
    {
        return ($this->users[$mail]);
    }
}
/* /listing 18.01 */
