<?php
declare(strict_types = 1);

namespace popp\r09\zestaw07;

/* listing 09.19 */
/* listing 09.17 */
class CommsManager
{
    const BLOGGS = 1;
    const MEGA = 2;
    private $mode;

    public function __construct(int $mode)
    {
        $this->mode = $mode;
    }

    public function getApptEncoder(): ApptEncoder
    {
        switch ($this->mode) {
            case (self::MEGA):
                return new MegaApptEncoder();
            default:
                return new BloggsApptEncoder();
        }
    }

/* /listing 09.17 */
    public function getHeaderText(): string
    {
        switch ($this->mode) {
            case (self::MEGA):
                return "Nagłówek MegaCal\n";
            default:
                return "Nagłówek BloggsCal\n";
        }
    }
/* listing 09.17 */
}
