<?php
declare(strict_types=1);
namespace popp\r08\zestaw03;

use popp\r08\zestaw02\Lecture;
use popp\r08\zestaw02\Seminar;
use popp\r08\zestaw02\CostStrategy;
use popp\r08\zestaw02\FixedCostStrategy;
use popp\r08\zestaw02\TimedCostStrategy;

abstract class Lesson
{
    private $duration;
    private $costStrategy;

/* listing 08.17 */
    public function __construct(int $duration, FixedCostStrategy $strategy)
    {
        $this->duration = $duration;
        $this->costStrategy = $strategy;
    }
/* /listing 08.17 */

    public function cost(): int
    {
        return $this->costStrategy->cost($this);
    }

    public function chargeType(): string
    {
        return $this->costStrategy->chargeType();
    }

    public function getDuration(): int
    {
        return $this->duration;
    }

    // pozostałe metody...
}

/*
abstract class CostStrategy
{
    public abstract function cost(Lesson $lesson):int ;
    public abstract function chargeType(): string;
}

class TimedCostStrategy extends CostStrategy
{
    public function cost(Lesson $lesson): int
    {
        return ( $lesson->getDuration() * 5 );
    }

    public function chargeType(): string
    {
        return "stawka godzinowa";
    }
}

class FixedCostStrategy extends CostStrategy
{
    public function cost(Lesson $lesson): int
    {
        return 30;
    }

    public function chargeType(): string
    {
        return "stawka stała";
    }
}

class Lecture extends Lesson
{
    // implementacja właściwa dla wykładów
}

class Seminar extends Lesson
{
    // implementacja właściwa dla seminariów
}
*/
