<?php
declare(strict_types=1);

namespace popp\r05\zestaw05;

use popp\r05\zestaw05\util as u;
use popp\r05\zestaw05\util\db\Querier as q;
use popp\r04\zestaw02\BookProduct;

class Runner
{

    public static function runbefore()
    {
/* listing 05.21 */
        $classname = "Task";
        require_once("tasks/{$classname}.php");
        $classname = "tasks\\$classname";
        $myObj = new $classname();
        $myObj->doSpeak();
/* /listing 05.21 */
    }

    public static function run()
    {
/* listing 05.22 */
        $base = __DIR__;
        $classname = "Task";
        $path = "{$base}/tasks/{$classname}.php";
        if (! file_exists($path)) {
            throw new \Exception("Nie istnieje plik {$path}");
        }
        require_once($path);
        $qclassname = "tasks\\$classname";
        if (! class_exists($qclassname)) {
            throw new Exception("Nie istnieje klasa $qclassname");
        }
        $myObj = new $qclassname();
        $myObj->doSpeak();
/* /listing 05.22 */
    }

/* listing 05.24 */
    public static function getProduct()
    {
        return new CdProduct(
            "Exile on Coldharbour Lane",
            "The",
            "Alabama 3",
            10.99,
            60.33
        );
    }
/* /listing 05.24 */

    public static function getBookProduct()
    {
        return new BookProduct(
            "Catch 22",
            "Joseph",
            "Heller",
            11.99,
            300
        );
    }

    public static function run2()
    {

/* listing 05.23 */
        $product = self::getProduct();
        if (get_class($product) === 'popp\r05\zestaw05\CdProduct') {
            print "\$product to obiekt klasy CdProduct\n";
        }
/* /listing 05.23 */

/* listing 05.25 */
        $product = self::getProduct();
        if ($product instanceof \popp\r05\zestaw05\CdProduct) {
            print "\$product jest egzemplarzem klasy CdProduct\n";
        }
/* /listing 05.25 */
    }

    public static function run3()
    {
        print u\Writer::class."\n";
        print q::class."\n";
        print Local::class."\n";
    }

    public static function run4()
    {
        print_r(get_class_methods('\\popp\\r04\\zestaw02\\BookProduct'));
    }

    public static function run5()
    {
/* listing 05.26 */
        $product = self::getProduct();
        $method = "getTitle";   // konstrukcja nazwy metody
        print $product->$method(); // wywołanie metody
/* /listing 05.26 */

/* listing 05.27 */
        if (in_array($method, get_class_methods($product))) {
            print $product->$method(); // wywołanie metody
        }
/* /listing 05.27 */

        if (is_callable(array( $product, $method))) {
            print $product->$method(); // wywołanie metody
        }

/* listing 05.28 */
        if (method_exists($product, $method)) {
            print $product->$method(); // wywołanie metody
        }
/* /listing 05.28 */

        print_r(get_class_vars('\\popp\\r05\\zestaw05\\CdProduct'));

        print get_parent_class('\\popp\\r04\\zestaw02\\BookProduct');

/* listing 05.29 */
        $product = self::getBookProduct(); // pozyskanie obiektu...

        if (is_subclass_of($product, '\\popp\\r04\\zestaw02\\ShopProduct')) {
            print "BookProduct to klasa pochodna klasy ShopProduct\n";
        }
/* /listing 05.29 */


/* listing 05.30 */
        if (in_array('someInterface', class_implements($product))) {
            print "BookProduct jest interfejsem someInterface\n";
        }
/* /listing 05.30 */

/* listing 05.31 */
        $product = self::getBookProduct(); // pozyskanie obiektu typu BookProduct
        call_user_func([$product, 'setDiscount'], 20);
/* /listing 05.31 */
    }
}
