<?php
require_once( "parse/Parser.php" );
require_once( "parse/MarkLogic.php" );

abstract class Question {
    protected $prompt;
    protected $marker;

    function __construct( $prompt, Marker $marker ) {
        $this->prompt=$prompt;
        $this->marker=$marker;
    }

    function mark( $response ) {
        return $this->marker->mark( $response );
    }
}

class TextQuestion extends Question {
    // dla pytania tekstowego
}

class AVQuestion extends Question {
    // dla pytania audiowizualnego
}

abstract class Marker {
    protected $test;

    function __construct( $test ) {
        $this->test = $test;
    }

    abstract function mark( $response );
}

class MarkLogicMarker extends Marker {
    private $engine;
    function __construct( $test ) {
        parent::__construct( $test );
        $this->engine = new MarkParse( $test );
    }

    function mark( $response ) {
        return $this->engine->evaluate( $response );
    }
}

class MatchMarker extends Marker {
    function mark( $response ) {
        return ( $this->test == $response );
    }
}

class RegexpMarker extends Marker {
    function mark( $response ) {
        return ( preg_match( "$this->test", $response ) );
    }
}

$markers = array(   new RegexpMarker( "/pi../" ),
                    new MatchMarker( "pięć" ),
                    new MarkLogicMarker( '$input equals "pięć"' )
        );

foreach ( $markers as $marker ) {
    print get_class( $marker )."\n";
    $question = new TextQuestion( "ile boków ma pięciobok", $marker );
    foreach ( array( "pięć", "cztery" ) as $response ) { 
        print "\tresponse: $response: ";
        if ( $question->mark( $response ) ) {
            print "dobra robota\n";
        } else {
            print "nic takiego\n";
        }
    }
}

?>
