<?php
/**
 * @license   http://www.example.com Borsetshire Open License
 * @package   command
 */

/**
 * Ujmuje dane przekazywane do, z i pomiędzy obiektami Command.
 * Obiekty klas Command wymagają dostarczenia dodatkowych danych
 * kontekstu wykonania zadania. Do metody Command::execute()
 * zadania przekazywany jest więc obiekt CommandContext, zawierający
 * dane w formacie klucz-wartość. Klasa CommandContext automatycznie
 * ładuje obiekt zawartością superglobalnej zmiennej $_REQUEST.
 *
 * @package command
 * @author  Clarrie Grundie
 * @copyright 2007 Ambridge Technologies Ltd
 */

class CommandContext {
/**
 * Nazwa aplikacji.
 * Wykorzystywana przez klientów w komunikatach o błędach itp..
 * @var string
 */
    public $applicationName;

/**
 * Ujmowane pary klucz-wartość.
 * Cała klasa CommandContext jest zasadniczo wrapperem tej tablicy.
 * @var array
 */
    private $params = array();

/**
 * Komunikat o błędzie.
 * @var string
 */
    private $error = "";

    function __construct( $appname ) {
        $this->params = $_REQUEST;
        $this->applicationName = $appname;
    }

    function addParam( $key, $val ) { 
        $this->params[$key]=$val;
    }

    function get( $key ) { 
        return $this->params[$key];
    }

    function setError( $error ) {
        $this->error = $error;
    }

    function getError() {
        return $this->error;
    }
}

?>
