<?php
/**
 * @license   http://www.example.com Borsetshire Open License
 * @package   command
 */

/**
 * Definiuje rdzenne funkcje poleceń.
 * Klasy hierarchii Command realizują konkretne zadania
 * w systemie za pośrednictwem metody
 * {@link execute()} 
 *
 * @package command
 * @author  Clarrie Grundie
 * @copyright 2007 Ambridge Technologies Ltd
 */
abstract class Command {

/**
 * Wykonuje zadanie ujęte w obiekcie klasy.
 * Klasy Command ujmują pojedyncze operacje; łatwo je dodawać do
 * projektu i z niego usuwać, a egzemplarze klas mogą być przechowywane
 * do późniejszego wykonania metody execute().
 *
 * @param  $context {@link CommandContext} wspólne dane kontekstowe
 * @return bool     false w przypadku niepowodzenia, true w przypadku powodzenia
 * @uses CommandContext
 * @link http://www.example.com More info
 */
    abstract function execute( CommandContext $context );
}


?>
