<?php

function getProductFileLines( $file ) {
    return file( $file );
}

function getProductObjectFromId( $id, $productname ) {
    // przeszukiwanie bazy danych
    return new Product( $id, $productname );
}

function getNameFromLine( $wiersz ) {
    if ( preg_match( "/.*-(.*)\s\d+/", $line, $array ) ) {
        return str_replace( '_',' ', $array[1] );
    }
    return '';
}

function getIDFromLine( $wiersz ) {
    if ( preg_match( "/^(\d{1,3})-/", $line, $array ) ) {
        return $array[1];
    }
    return -1;
}

class Product {
    public $id;
    public $name;
    function __construct( $id, $name ) {
        $this->id = $id;
        $this->name = $name;
    }
}

$lines = getProductFileLines( 'test.txt' );
$objects = array();
foreach ( $lines as $wiersz ) {
    $id = getIDFromLine( $wiersz );
    $name = getNameFromLine( $wiersz );
    $objects[$id] = getProductObjectFromID( $id, $name  );
}

print_r( $objects );
?>
