<?php

class XmlException extends Exception {
    private $error;

    function __construct( LibXmlError $error ) {
        $shortplik = basename( $error->plik );
	print_r( $error );
        $msg = "[{$shortfile}, wiersz {$error->line}, kolumna {$error->column}] {$error->message}";
        $this->error = $error;
        parent::__construct( $msg, $error->code );
    }

    function getLibXmlError() {
        return $this->error;
    }
}

class FileException extends Exception { }
class ConfException extends Exception { }

class Conf {
    private $file;
    private $xml;
    private $lastmatch;

    function __construct( $plik ) {
        $this->plik = $file;
        if ( ! file_exists( $plik ) ) {
            throw new FileException( "brak pliku '$file'" );
        }
        $this->xml = simplexml_load_file($file, null, LIBXML_NOERROR );
        if ( ! is_object( $this->xml ) ) {
            throw new XmlException( libxml_get_last_error() );
        }
        $matches = $this->xml->xpath("/conf");
        if ( ! count( $matches ) ) {
            throw new ConfException( "brak elementu głównego: conf" );
        }
    }    

    function write() {
        if ( ! is_writeable( $this->plik ) ) {
            throw new Exception("plik '{$this->file}' jest niemodyfikowalny");
        }
        file_put_contents( $this->file, $this->xml->asXML() );
    }

    function get( $str ) {
        $matches = $this->xml->xpath("/conf/item[@name=\"$str\"]");
        if ( count( $matches ) ) {
            $this->lastmatch = $matches[0];
            return (string)$matches[0];
        }
        return null;
    }

    function set( $key, $value ) {
        if ( ! is_null( $this->get( $key ) ) ) {
            $this->lastmatch[0]=$value;
            return;
        }
        $conf = $this->xml->conf;
        $this->xml->addChild('item', $value)->addAttribute( 'name', $key );
    }
}


class Runner {
    static function init() { 
        try {
            $conf = new Conf( dirname(__FILE__)."/conf.broken.xml" );
            print "użytkownik: ".$conf->get('user')."\n";
            print "host: ".$conf->get('host')."\n";
            $conf->set("pass", "newpass");
            $conf->write();
        } catch ( FileException $e ) {
            // problem uprawnień albo braku pliku
            throw $e;
        } catch ( XmlException $e ) {
            // popsuty XML
        } catch ( ConfException $e ) {
            // zły rodzaj pliku XML
        } catch ( Exception $e ) {
            // nie powinniśmy tu dotrzeć
        }
    }
}

Runner::init();

?>
