<?php
class UserStore {
    private $users = array();

    function addUser( $name, $mail, $pass ) {

        if ( isset( $this->users[$mail] ) ) {
            throw new Exception(
                "Konto {$mail} jest już obecne w systemie");
        }

        if ( strlen( $pass ) < 5 ) {
            throw new Exception(
                "Hasło ma mieć co najmniej 5 znaków");
        }

        $this->users[$mail] = array( 'pass' => $pass,
                                     'mail' => $mail,
                                     'name' => $name );
        return true;
    }

    function notifyPasswordFailure( $mail ) {
        if ( isset( $this->users[$mail] ) ) {
            $this->users[$mail]['failed']=time();
        }
    }


    function getUser( $mail ) {
        return ( $this->users[$mail] );
    }
}
$store=new UserStore();
$store->addUser(  "bob williams",
                  "bob@example.com",
                  "12345" );
$store->notifyPasswordFailure(  "bob@example.com" );
$user = $store->getUser(  "bob@example.com" );
print_r( $user );
?>
