<?php
require 'settings.php';

// połączenie PDO
try {
    $pdo = new PDO(
        sprintf(
            'mysql:host=%s;dbname=%s;port=%s;charset=%s',
            $settings['host'],
            $settings['name'],
            $settings['port'],
            $settings['charset']
        ),
        $settings['username'],
        $settings['password']
    );
} catch (PDOException $e) {
    // brak połączenia z bazą danych
    echo "Brak połączenia z bazą danych.";
    exit;
}

// budowa i wykonanie zapytania SQL
$sql = 'SELECT id, email FROM users WHERE email = :email';
$statement = $pdo->prepare($sql);
$email = filter_input(INPUT_GET, 'email');
$statement->bindValue(':email', $email, PDO::PARAM_INT);

// iteracja przez wyniki
echo 'Po jednym wyniku na raz', PHP_EOL;
$statement->execute();
while (($result = $statement->fetch(PDO::FETCH_ASSOC)) !== false) {
    echo $result['email'], PHP_EOL;
}

// Iterate ALL results at once
echo 'Wszystkie wyniki na raz jako tablica asocjacyjna', PHP_EOL;
$statement->execute();
$allResults = $statement->fetchAll(PDO::FETCH_ASSOC);
foreach ($allResults as $result) {
    echo $result['email'], PHP_EOL;
}

// pobranie jednej kolumny na raz
echo 'Pobranie jednej kolumny, jednego wiersza na raz jako tablicy asocjacyjnej', PHP_EOL;
$statement->execute();
while (($email = $statement->fetchColumn(1)) !== false) {
    echo $email, PHP_EOL;
}

// iteracja przez wyniki jako obiekty
echo 'Jeden wynik na raz jako obiekt', PHP_EOL;
$statement->execute();
while (($result = $statement->fetchObject()) !== false) {
    echo $result->email, PHP_EOL;
}
