<?php
try {
    // sprawdzenie adresu e-mail
    $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    if (!$email) {
        throw new Exception('Niepoprawny adres e-mail');
    }

    // sprawdzenie hasła
    $password = filter_input(INPUT_POST, 'password');
    if (!$password || mb_strlen($password) < 8) {
        throw new Exception('Hasło musi zawierać przynajmniej osiem znaków');
    }

    // utworzenie skrótu hasła
    $passwordHash = password_hash(
       $password,
       PASSWORD_DEFAULT,
       ['cost' => 12]
    );
    if ($passwordHash === false) {
        throw new Exception('Nie udało się utworzyć skrótu hasła');
    }

    // Utworzenie konta użytkownika (pseudokod)
    // $user = new User();
    // $user->email = $email;
    // $user->password_hash = $passwordHash;
    // $user->save();

    // przekierowanie na stronę logowania
    header('HTTP/1.1 302 Redirect');
    header('Location: /login.php');
} catch (Exception $e) {
    // zgłoszenie błędu
    header('HTTP/1.1 400 Bad request');
    echo $e->getMessage();
}
