<?php
// użycie loadera Composera
require 'vendor/autoload.php';

// import przestrzeni nazw komponentu Monolog
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Monolog\Handler\SwiftMailerHandler;

date_default_timezone_set('Europe/Warsaw');

// konfiguracja komponentu Monolog i podstawowej procedury obsługowej
$log = new Logger('my-app-name');
$log->pushHandler(new StreamHandler('logs/production.log', Logger::WARNING));

// dodanie procedury SwiftMailer dla błędów krytycznych
$transport = \Swift_SmtpTransport::newInstance('smtp.example.com', 587)
             ->setUsername('nazwaużytkownika')
             ->setPassword('hasło');
$mailer = \Swift_Mailer::newInstance($transport);
$message = \Swift_Message::newInstance()
           ->setSubject('Błąd w witrynie!')
           ->setFrom(array('daemon@example.com' => 'Jan Kowalski'))
           ->setTo(array('admin@example.com'));
$log->pushHandler(new SwiftMailerHandler($mailer, $message, Logger::CRITICAL));

// użycie rejestratora
$log->critical('Serwer się pali!');
