<?php

declare(strict_types=1);

namespace DesignPatterns\FactoryMethod;

class CsvEncoder implements Encoder
{
    public function encode(array $data): string
    {
        // Funkcja fputcsv nie może zapisywać danych wyjściowych do łąńcucha,
        // znaków, więc korzystamy tu z z opakowania w postaci strumienia, by 
        // dane te zapisać najpierw do pamięci, a dopiero z niej do łańcucha.
        $f = fopen('php://memory', 'rb+');

        foreach ($data as $row) {
            fputcsv($f, $row);
        }

        rewind($f);

        return stream_get_contents($f);
    }
}