<?php

declare(strict_types=1);

namespace DesignPatterns\DependencyInjection;

class ConstructorInjection
{
    private Logger $logger;

    public function __construct(Logger $logger)
    {
        $this->logger = $logger;
    }

    public function doSomething(): void
    {
        // Tu następuje jakieś działanie.

        // Zarejestrujmy coś w dzienniku.
        $this->logger->log('Wykonano pewną operację.');
    }
}

$constructorInjection = new ConstructorInjection(
    new FileLogger()
);