<?php
declare(strict_types = 1); // dbamy o prawidłowe typy danych

define('ERROR_CODE', 4); // definicja stałej

// definicja niestandardowej klasy do obsługi wyjątków
class MyException extends Exception {
    public function errorMessage() {
        return sprintf("Wystąpił błąd '%s' o numerze %d w linii %d.".PHP_EOL,
        $this->getMessage(), $this->getCode(), $this->getLine());
      }
}

// funkcja anonimowa przypisana do zmiennej
$kalkulator = function(string $operacja, float $x, float $y) : float
{
    if ($operacja == '/' && $y == 0) {
        // zgłoś wyjątek do wcześniej zdefiniowanej klasy MyException
        throw new MyException('Nie dziel przez zero!', ERROR_CODE);
    }

    return match($operacja) {
        '+' => $x + $y,
        '-' => $x - $y,
        '*' => $x * $y,
        '/' => fdiv($x, $y),
    };
};

try {
    print $kalkulator(operacja: '/', x: 5, y: 2); // dzielimy przez 2
    print PHP_EOL;
    print $kalkulator(operacja: '/', x: 5, y: 0); // próbujemy dzielić przez 0
} catch (\Exception $e) {
    print $e->errorMessage();
}