<?php
try {
    $db_file = 'UczestnicyBalu.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // utwórz tabelę, jeśli nie została wcześniej utworzona
    $db_pdo->exec(
        "CREATE TABLE IF NOT EXISTS UczestnicyBalu
        (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        imie TEXT DEFAULT '',
        postac TEXT DEFAULT '',
        wiek INTEGER DEFAULT 0
        );"
    );

    /* dodawanie rekordów do tabeli */
    $db_pdo->exec("INSERT INTO UczestnicyBalu (imie, postac, wiek) 
    VALUES ('Ariel', 'Szeryf', 8);");
    $db_pdo->exec("INSERT INTO UczestnicyBalu (imie, postac, wiek) 
    VALUES ('Róża', 'Księżniczka', 6);");

    $db_pdo = null; // zamknij połączenie z bazą

    // sprawdź, czy plik z bazą został utworzony
    if (file_exists($db_file)) {
        print "Plik z bazą danych SQLite został utworzony!";
    }
} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}