<?php
declare(strict_types=1);

namespace popp\r12\zestaw05;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch05Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });

        //print $val;
        self::assertMatchesRegularExpression("/Witamy w WOO/", $val);

        $e = new AppException();    
        self::assertTrue($e instanceof AppException);
    }

    public function testRegistry() {
        $request = new TestRequest();
        $reg = Registry::instance();
        $reg->setRequest($request);

        $conf = $reg->getConf();
        self::assertTrue($conf instanceof Conf);

        $request = $reg->getRequest();
        self::assertTrue($request instanceof Request);
    }

    public function testApplicationHelper() {
        $helper = new ApplicationHelper();
            $helper->init();
        $reg = Registry::instance();
        $dsn = $reg->getDSN();
        self::assertEquals($dsn, "sqlite:/var/popp/src/r12/zestaw05/data/woo.db");
    }

    public function testCommandResolver() {

        // konfiguracja podstawowa
        $request = new TestRequest();
        $reg = Registry::instance();
        $reg->setRequest($request);

        $commands = new Conf();
        $resolver = new CommandResolver();         

        //$commands->set("testcmd", "\\popp\\test\\r12\\TestCommand");

        // brak ściezki
        $reg->setCommands($commands);
        $cmd = $resolver->getCommand($request);
        $feedback = $request->getFeedback();
        self::assertEquals($feedback[0], "nie dopasowano ścieżki '/'");
        self::assertTrue($cmd instanceof DefaultCommand);

        // brak dopasowania ściezki
        $request->clearFeedback();
        $request->setPath("/testcmd");
        $cmd = $resolver->getCommand($request);
        $feedback = $request->getFeedback();
        self::assertEquals($feedback[0], "nie dopasowano ścieżki '/testcmd'");
        self::assertTrue($cmd instanceof DefaultCommand);

        // dopasowano ścieżkę, ale nie klasę
        $request->clearFeedback();
        $commands->set("/testcmd", "\\popp\\NoSuchClass");
        $request->setPath("/testcmd");
        $cmd = $resolver->getCommand($request);
        $feedback = $request->getFeedback();
        self::assertEquals($feedback[0], "nie odnaleziono klasy '\\popp\\NoSuchClass'");
        self::assertTrue($cmd instanceof DefaultCommand);

        // dopasowano ścieżkę i klasę
        $request->clearFeedback();
        $commands->set("/testcmd", "\\popp\\test\\r12\\TestCommandBatch05");
        $request->setPath("/testcmd");
        $cmd = $resolver->getCommand($request);
        $feedback = $request->getFeedback();
        self::assertEquals(count($feedback), 0);
        self::assertTrue($cmd instanceof \popp\test\ch12\TestCommandBatch05);
    }
}


