<?php

declare(strict_types=1);

namespace popp\r24\zestaw01;

use popp\r24\zestaw01\marklogic\MarkParse;

class MarkLogicMarker extends Marker
{
    private MarkParse $engine;

    public function __construct(string $test)
    {
        parent::__construct($test);
        $this->engine = new MarkParse($test);
    }

    public function mark(string $response): bool
    {
        return $this->engine->evaluate($response);
    }
}
