<?php

declare(strict_types=1);

namespace popp\r12\zestaw08;

/* listing 12.36 */
class AddVenueController extends PageController
{
    public function process(): void
    {
        $request = $this->getRequest();

        try {
            $name = $request->getProperty('venue_name');

            if (is_null($request->getProperty('submitted'))) {
                $request->addFeedback("wybierz nazwę placówki");
                $this->render(__DIR__ . '/view/add_venue.php', $request);
            } elseif (is_null($name)) {
                $request->addFeedback("nazwa jest polem wymaganym");
                $this->render(__DIR__ . '/view/add_venue.php', $request);

                return;
            } else {
                // dodaj do bazy danych
                $this->forward('listvenues.php');
            }
        } catch (Exception) {
            $this->render(__DIR__ . '/view/error.php', $request);
        }
    }
}
/* /listing 12.36 */
