<?php

declare(strict_types=1);

namespace popp\r11\zestaw09;

/* listing 11.51 */
class CommandFactory
{
    private static string $dir = 'commands';

    public static function getCommand(string $action = 'Default'): Command
    {
        if (preg_match('/\W/', $action)) {
            throw new \Exception("niedozwolone znaki parametru");
        }

        $class = __NAMESPACE__ . "\\commands\\" . UCFirst(strtolower($action)) . "Command";

        if (! class_exists($class)) {
            throw new CommandNotFoundException("nie można znaleźć klasy '$class'");
        }

        $cmd = new $class();

        return $cmd;
    }
}
