<?php
declare(strict_types=1);

namespace popp\r13\zestaw07;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch07Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        self::assertMatchesRegularExpression("/^name = 'Wielki pokaz' AND start > \d+ AND start < \d+/", $val);
        
        $val = $this->capture(function() { Runner::run2(); });
        self::assertEquals("banan nie jest poprawną nazwą pola (name, id, start, duration, space)", $val);

        $val = $this->capture(function() { Runner::run3(); });
        self::assertMatchesRegularExpression("/UPDATE venue SET name = \? WHERE id = \?/", $val);
        self::assertMatchesRegularExpression("/Weseli Brodacze/", $val);
        self::assertMatchesRegularExpression("/334/", $val);

        $val = $this->capture(function() { Runner::run3_1(); });
        self::assertMatchesRegularExpression("/Samotny Kapelusznik/", $val);

        $val = $this->capture(function() { Runner::run4(); });
        self::assertMatchesRegularExpression("/SELECT name,id FROM venue WHERE name = \?/", $val);
        self::assertMatchesRegularExpression("/Weseli Brodacze/", $val);

        $val = $this->capture(function() { Runner::run5(); });
        $expected = "Gospoda pod Okiem\nGospoda pod Okiem\nGospoda pod Okiem\n";
        self::assertEquals($expected, $val);
    }
}
