<?php

namespace popp\r10;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

use popp\r10\zestaw04\Army;
use popp\r10\zestaw04\Soldier;
use popp\r10\zestaw04\Tank;
use popp\r10\zestaw04\Runner;
use popp\r10\zestaw04\Archer;

class Batch04Test extends BaseUnit
{
    public function testArmy()
    {
        $tank =  new Tank();
        $tank2 = new Tank();
        $soldier = new Soldier();

        $army = new Army();
        $army->addUnit($soldier);
        $army->addUnit($tank);
        $army->addUnit($tank2);

        self::assertEquals(count($army->getUnits()), 3);
        $army->removeUnit($tank2);
        self::assertEquals(count($army->getUnits()), 2);
    }

    public function testArcher()
    {
        $archer = new Archer();
        $tank =  new Tank();
        try {
            $archer->addUnit($tank);
            self::fail("Powinien zostać wyrzucony wyjątek");
        } catch (\Exception $e) {
            self::assertEquals($e->getMessage(), "popp\\r10\\zestaw04\\Archer to liść");
        }
    }

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        self::assertEquals($val, "Atak z siłą: 60\n");
        //print $val;
    }

}
