<?php
declare(strict_types=1);

namespace popp\r05\zestaw07;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch07Test extends BaseUnit 
{

    public function testRunner()
    {
//        $val = $this->capture(function() { Runner::run(); });
//        print $val;

        $val = $this->capture(function() { Runner::run2(); });
        self::assertMatchesRegularExpression("/getInstance/", $val); 
        $val = $this->capture(function() { Runner::run3(); });

        self::assertMatchesRegularExpression("/producerFirstName/", $val);


        $val = $this->capture(function() { Runner::run4(); });
        $expected = <<<EXPECTED
popp\r04\zestaw02\CdProduct to klasa definiowana przez użytkownika
popp\r04\zestaw02\Można tworzyć obiekty klasy CdProduct
popp\r04\zestaw02\Można klonować obiekty klasy CdProduct

EXPECTED;

        self::assertEquals($expected, $val);

        $val = $this->capture(function() { Runner::run5(); });
        self::assertMatchesRegularExpression("/getSummaryLine/", $val); 
        
        $val = $this->capture(function() { Runner::run6(); });
        self::assertMatchesRegularExpression("/getDiscount to metoda definiowana przez użytkownika/", $val); 

        $val = $this->capture(function() { Runner::run7(); });
        self::assertMatchesRegularExpression("/public function getSummaryLine\(\): string/", $val); 

        $val = $this->capture(function() { Runner::run8(); });

        $rmethods = Runner::runInstantiateMethod();
        foreach ($rmethods as $rmethod) {
            self::assertTrue($rmethod instanceof \ReflectionMethod);
        }

        $rparams = Runner::runInstantiateParameter();
        foreach ($rparams as $rparam) {
            self::assertTrue($rparam instanceof \ReflectionParameter);
        }
    }
}
