<?php

namespace popp\r03;

require_once("vendor/autoload.php");
use PHPUnit\Framework\TestCase;

use popp\r03\zestaw08\AddressManager;

// nie ma potrzeby tworzenia kopii
use popp\r03\zestaw04\ShopProduct;
use popp\r03\zestaw08\ShopProductWriter;
use popp\r03\zestaw08\Runner;

class Batch08Test extends TestCase
{
    public function testAddressManager()
    {
        $aman = new AddressManager();
        self::assertTrue($aman instanceof AddressManager);
        self::assertFalse($aman->outputAddresses("false"));
        self::assertTrue($aman->outputAddresses(true));
    }

    public function testProductWriter()
    {
        
        $product = new ShopProduct("title", "first", "main", 99);
        self::assertTrue($product instanceof ShopProduct);
        self::assertEquals($product->title, "title");
        self::assertEquals($product->producerFirstName, "first");
        self::assertEquals($product->producerMainName, "main");
        self::assertEquals($product->price, 99);
        $spw = new ShopProductWriter();

        ob_start();
        $spw->write($product);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("title: first main (99)\n", $output1);
      
        // usuń poniższy komentarz, aby wywołać błąd krytyczny spowodowany przekazaniem złego typu do metody write()
        // Runner::run1();
    }
}
