<?php
declare(strict_types=1);

namespace popp\r12\zestaw10;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;
use popp\r12\zestaw06\Registry;

class Batch10Test extends BaseUnit 
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        //print $val;
        
        $reg = Registry::instance();
        $dsn = $reg->getDsn();
        $pdo = new \PDO($dsn);
        $query = "SELECT * from venue where name='Gospoda pod Okiem'";
        $stmt = $pdo->prepare($query);
        $stmt->execute();
        $rows = [];
        while($row = $stmt->fetch()) {
            $rows[] = $row;
        }
        self::assertEquals(1, count($rows));
    }
}
