<?php

namespace popp\r18\zestaw04\woo\domain;

use popp\r18\zestaw04\woo\base\AppException;

class HelperFactory
{
    private static $package = "\\popp\\r18\\zestaw04\\woo\\mapper";

    public static function getFinder($type)
    {
        $type = preg_replace('|^.*\\\|', "", $type);
        $mapper = self::$package . "\\{$type}Mapper";
        if (class_exists($mapper)) {
            return new $mapper();
        }
        throw new AppException("Nieznana: $mapper");
    }

    public static function getCollection($type)
    {
        $type = preg_replace('|^.*\\\|', "", $type);
        $collection = self::$package . "\\{$type}Collection";
        if (class_exists($collection)) {
            return new $collection();
        }
        throw new AppException("Nieznana: $collection");
    }
}
