<?php

namespace popp\r18\zestaw04\woo\command;

use popp\r18\zestaw04\woo\domain\Venue;
use popp\r18\zestaw04\woo\controller\Request;

class AddVenue extends Command
{
    protected function doExecute(Request $request)
    {
        $name = $request->getProperty("venue_name");
        if (is_null($name)) {
            $request->addFeedback("nie dostarczono nazwy");
            return self::statuses('CMD_INSUFFICIENT_DATA');
        } else {
            $venue_obj = new Venue(null, $name);
            $request->setObject('venue', $venue_obj);
            $venue_obj->finder()->insert($venue_obj);
            $request->addFeedback("'$name' dodano ({$venue_obj->getId()})");
            return self::statuses('CMD_OK');
        }
        return self::statuses('CMD_DEFAULT');
    }
}
