<?php

declare(strict_types=1);

namespace popp\r08\zestaw03;

use popp\r08\zestaw02\Lecture;
use popp\r08\zestaw02\Seminar;
use popp\r08\zestaw02\CostStrategy;
use popp\r08\zestaw02\FixedCostStrategy;
use popp\r08\zestaw02\TimedCostStrategy;

abstract class Lesson
{

/* listing 08.18 */
    public function __construct(private int $duration, private FixedCostStrategy $costStrategy)
    {
    }
/* /listing 08.18 */

    public function cost(): int
    {
        return $this->costStrategy->cost($this);
    }

    public function chargeType(): string
    {
        return $this->costStrategy->chargeType();
    }

    public function getDuration(): int
    {
        return $this->duration;
    }

    // pozostałe metody
}
