<?php

declare(strict_types=1);

namespace popp\r24\zestaw01\marklogic;

use popp\r24\zestaw01\parse\Handler;
use popp\r24\zestaw01\parse\Parser;
use popp\r24\zestaw01\parse\Scanner;
use popp\r24\zestaw01\interpreter\LiteralExpression;

/* listing 24.21 */
class StringLiteralHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner): void
    {
        $value = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new LiteralExpression($value));
    }
}
