<?php

declare(strict_types=1);

namespace popp\r12\zestaw09;

use popp\r12\zestaw06\Registry;
use popp\r12\zestaw06\Request;
use popp\r12\zestaw06\HttpRequest;
use popp\r12\zestaw08\CliRequest;

abstract class PageController
{
    abstract public function process(): void;

    public function init(): void
    {
        $reg = Registry::instance();

        if (isset($_SERVER['REQUEST_METHOD'])) {
            $request = new HttpRequest();
        } else {
            $request = new CliRequest();
        }

        $reg->setRequest($request);
    }

    public function forward(string $resource): void
    {
        $request = $this->getRequest();
        $request->forward($resource);
    }

/* listing 12.40 */
    public function render(string $resource, Request $request): void
    {
        $vh = new ViewHelper();
        // odtąd szablon będzie dysponował zmienną $vh
        include($resource);
    }
/* /listing 12.40 */

    public function getRequest(): Request
    {
        $reg = Registry::instance();
        return $reg->getRequest();
    }
}
