<?php

declare(strict_types=1);

namespace popp\r04\zestaw03;

/* listing 04.13 */
class XmlProductWriter extends ShopProductWriter
{

    public function write(): void
    {
        $writer = new \XMLWriter();
        $writer->openMemory();
        $writer->startDocument('1.0', 'UTF-8');
        $writer->startElement("products");
        foreach ($this->products as $shopProduct) {
            $writer->startElement("product");
            $writer->writeAttribute("title", $shopProduct->getTitle());
            $writer->startElement("summary");
            $writer->text($shopProduct->getSummaryLine());
            $writer->endElement(); // podsumowanie
            $writer->endElement(); // produkt
        }
        $writer->endElement(); // produkty
        $writer->endDocument();
        print $writer->flush();
    }
}
