<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

$inputStr = 'Bingo';
$fruites = ['Jabłko', 'Pomarańcza', 'Winogrono', 'Banan', 'Arbuz', 'Mango'];

$matchScore = -1;
$matchedStr = '';

foreach ($fruites as $fruit) {
   $tmpScore = levenshtein($inputStr, $fruit);

   if ($tmpScore == 0 || ($matchScore < 0 || $matchScore > $tmpScore)) {
      $matchScore = $tmpScore;
      $matchedStr = $fruit;
   }
}

echo $matchScore == 0 ? 'Znaleziono dokładne dopasowanie: ' . $matchedStr :'Czy chodziło Ci o ' . $matchedStr . '?\n';


$str1 = "Mango";
$str2 = "Tango";

echo "Długość dopasowania: " . similar_text($str1, $str2) . "\n";
similar_text($str1, $str2, $percent);
echo "Dopasowanie procentowe: " . $percent . "%";


$word1 = "Pray";
$word2 = "Prey";
echo $word1 . " = " . soundex($word1) . "\n";
echo $word2 . " = " . soundex($word2) . "\n";

$word3 = "There";
$word4 = "Their";
echo $word3 . " = " . soundex($word3) . "\n";
echo $word4 . " = " . soundex($word4) . "\n"; 


$word1 = "Pray";
$word2 = "Prey";
echo $word1 . " = " . metaphone($word1) . "\n";
echo $word2 . " = " . metaphone($word2) . "\n";

$word3 = "There";
$word4 = "Their";
echo $word3 . " = " . metaphone($word3) . "\n";
echo $word4 . " = " . metaphone($word4) . "\n"; 


$arr = ['plik1', 'plik2', 'plik10', 'plik11', 'plik3', 'plik15', 'plik21'];
sort($arr);
echo "Zwykłe sortowanie: " . implode(",", $arr)."\n";
natsort($arr);
echo "Naturalne sortowanie: " . implode(",", $arr);


$data = "witaj"; 

foreach (hash_algos() as $v) { 
   $r = hash($v, $data, false); 
   printf("%-12s %3d %s\n", $v, strlen($r), $r); 
}