<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

class BinaryTree {

public $nodes = [];

   public function __construct(Array $nodes) {
      $this->nodes = $nodes;
   }

   public function traverse(int $num = 0, int $level = 0) {

      if (isset($this->nodes[$num])) {
         echo str_repeat("-", $level);
         echo $this->nodes[$num] . "\n";

         $this->traverse(2 * $num + 1, $level+1);
         $this->traverse(2 * ($num + 1), $level+1);
      }
   }

}


try {

   $nodes = [];
   $nodes[] = "Finał";
   $nodes[] = "Półfinał 1";
   $nodes[] = "Półfinał 2";
   $nodes[] = "Ćwierćfinał 1";
   $nodes[] = "Ćwierćfinał 2";
   $nodes[] = "Ćwierćfinał 3";
   $nodes[] = "Ćwierćfinał 4";

   $tree = new BinaryTree($nodes);
   $tree->traverse(0);
   
} catch (Exception $e) {
   echo $e->getMessage();
}