<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

function treeTraverse(array &$tree, int $index = 0, int $level = 0, &$outputStr = "") : ?bool {

   if(isset($tree[$index])) {
      $outputStr .= str_repeat("-", $level);
      $outputStr .= $tree[$index] . "\n";
      treeTraverse($tree, 2 * $index + 1, $level+1,$outputStr);
      treeTraverse($tree, 2 * ($index + 1), $level+1,$outputStr);
   } else {
      return false;
   }
   return null;
}

$nodes = [];
$nodes[] = "Finał";
$nodes[] = "Półfinał 1";
$nodes[] = "Półfinał 2";
$nodes[] = "Ćwierćfinał 1";
$nodes[] = "Ćwierćfinał 2";
$nodes[] = "Ćwierćfinał 3";
$nodes[] = "Ćwierćfinał 4";

$treeStr = "";
treeTraverse($nodes,0,0,$treeStr);
echo $treeStr;