<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

class BinaryNode {

   public $data;
   public $left;
   public $right;

   public function __construct(string $data = NULL) {
      $this->data = $data;
      $this->left = NULL;
      $this->right = NULL;
   }

   public function addChildren(BinaryNode $left, BinaryNode $right) {
      $this->left = $left;
      $this->right = $right;
   }

}


class BinaryTree {

   public $root = NULL;

   public function __construct(BinaryNode $node) {
      $this->root = $node;
   }

   public function isEmpty(): bool {
      return $this->root === NULL;
   }

public function traverse(BinaryNode $node, int $level = 0) {

   if ($node) {
      echo str_repeat("-", $level);
      echo $node->data . "\n";

      if ($node->left)
         $this->traverse($node->left, $level + 1);

      if ($node->right)
         $this->traverse($node->right, $level + 1);
      }
   }

}


try {

   $final = new BinaryNode("Finał");

   $tree = new BinaryTree($final);

   $semiFinal1 = new BinaryNode("Półfinał 1");
   $semiFinal2 = new BinaryNode("Półfinał 2");

   $quarterFinal1 = new BinaryNode("Ćwierćfinał 1");
   $quarterFinal2 = new BinaryNode("Ćwierćfinał 2");
   $quarterFinal3 = new BinaryNode("Ćwierćfinał 3");
   $quarterFinal4 = new BinaryNode("Ćwierćfinał 4");

   $semiFinal1->addChildren($quarterFinal1, $quarterFinal2);
   $semiFinal2->addChildren($quarterFinal3, $quarterFinal4);

   $final->addChildren($semiFinal1, $semiFinal2);

   $tree->traverse($tree->root);

} catch (Exception $e) {
    echo $e->getMessage();
}