<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

interface Queue {

   public function enqueue(string $item);

   public function dequeue();

   public function peek();

   public function isEmpty();
}


class AgentQueue implements Queue {

   private $limit;
   private $queue;

   public function __construct(int $limit = 20) {
      $this->limit = $limit;
      $this->queue = [];
   }

   public function dequeue(): string {
      if ($this->isEmpty()) {
         throw new UnderflowException('Kolejka jest pusta');
      } else {
         return array_shift($this->queue);
      }
   }

   public function enqueue(string $newItem) {
      if (count($this->queue) < $this->limit) {
         array_push($this->queue, $newItem);
      } else {
         throw new OverflowException('Kolejka jest pełna');
      }
   }

   public function peek(): string {
      return current($this->queue);
   }

   public function isEmpty(): bool {
      return empty($this->queue);
   }

}


try {
   $agents = new AgentQueue(10);
   $agents->enqueue("Franek");
   $agents->enqueue("Janek");
   $agents->enqueue("Krzysiek");
   $agents->enqueue("Adrian");
   $agents->enqueue("Michał");
   echo $agents->dequeue()."\n";
   echo $agents->dequeue()."\n";
   echo $agents->peek()."\n";
} catch (Exception $e) {
   echo $e->getMessage();
}