<?php

/* 
 * Przykładowy kod do książki: Algorytmy i struktury danych w języku PHP 7
 * 
 * Autor: Mizanur Rahman <mizanur.rahman@gmail.com>
 * 
 */

class ListNode {

   public $data = NULL;
   public $next = NULL;

   public function __construct(string $data = NULL) {
     $this->data = $data;
   }

}

class CircularLinkedList {

   private $_firstNode = NULL;
   private $_totalNode = 0;

   public function insertAtEnd(string $data = NULL) {
      $newNode = new ListNode($data);
      if ($this->_firstNode === NULL) {
         $this->_firstNode = &$newNode;
      } else {
         $currentNode = $this->_firstNode;
         while ($currentNode->next !== $this->_firstNode) {
            $currentNode = $currentNode->next;
         }
         $currentNode->next = $newNode;
      }
      $newNode->next = $this->_firstNode;
      $this->_totalNode++;
      return TRUE;
   }

   public function display() {
      echo "Total book titles: " . $this->_totalNode . "\n";
      $currentNode = $this->_firstNode;
      while ($currentNode->next !== $this->_firstNode) {
         echo $currentNode->data . "\n";
         $currentNode = $currentNode->next;
      }

      if ($currentNode) {
         echo $currentNode->data . "\n";
      }
   }

}

$BookTitles = new CircularLinkedList();
$BookTitles->insertAtEnd("Wprowadzenie do algorytmów");
$BookTitles->insertAtEnd("Wprowadzenie do PHP i struktur danych");
$BookTitles->insertAtEnd("Programowanie sztucznej inteligencji");
$BookTitles->insertAtEnd("Samouczek administracji systemu Mediawiki");
$BookTitles->display();
